#
# Dark Channel ChannelServer Default Conf Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Node::ChannelServer::Conf::Defaults;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use Tie::IxHash;

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $conf);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( %CONF_DEFAULT $CONF_DEFAULT_NAME $CONF_DEFAULT_DIR);

# conf default name & path
our $CONF_DEFAULT_NAME = 'dcd.conf';

my $CONF_DIR_HOME = $ENV{HOME} . '/.darkchannel/channelserver';
my $CONF_DIR_ETC = '/etc/darkchannel';
our $CONF_DEFAULT_DIR = (`id -u` == 0) ? $CONF_DIR_ETC : $CONF_DIR_HOME;

# conf defaults
tie my %CONF_DEFAULT_GPG_EXECUTABLES, "Tie::IxHash";
%CONF_DEFAULT_GPG_EXECUTABLES =
(
    gpg                   => '/usr/bin/gpg',
    gpg_agent             => '/usr/bin/gpg-agent',
    gpg_connect_agent     => '/usr/bin/gpg-connect-agent',
    gpg_preset_passphrase => '/usr/libexec/gpg-preset-passphrase',
);
tie my %CONF_DEFAULT_GPG, "Tie::IxHash";
%CONF_DEFAULT_GPG =
(
    gpg_storage_mode      => 0700,
    gpg_keylength         => 2048, # 1024, 2048, 4096
    gpg_logfile           => 0,    # 'log/gpg.log'
    gpg_passphrase        => 'abc',
    gpg_executables       => \%CONF_DEFAULT_GPG_EXECUTABLES,
);
tie my %CONF_DEFAULT_LOG, "Tie::IxHash";
%CONF_DEFAULT_LOG =
(
    log_crit => 1,
    log_err  => 1,
    log_warn => 1,
    log_info => 1,
    log_dbg  => 1,

    log_dbg_transition          => 1,
    log_dbg_interpreter         => 1,
    log_dbg_verify              => 1,
    log_dbg_request             => 1,
    log_dbg_response            => 1,
    log_dbg_request_transport   => 0,
    log_dbg_response_transport  => 0,
    log_dbg_splitblock          => 0,
    log_dbg_input               => 0,

    log_dbg_gpg                 => 1,
    log_dbg_gpg_keygen          => 0,
    log_dbg_gpg_keyinfo         => 0,
    log_dbg_gpg_sign            => 0,
    log_dbg_gpg_encrypt         => 0,
    log_dbg_gpg_decrypt         => 0,
    log_dbg_gpg_verify          => 0,
    log_dbg_gpg_import          => 0,
    log_dbg_gpg_export          => 0,
    log_dbg_gpg_inspect         => 0,
    log_dbg_gpg_key_sign        => 0,
    log_dbg_gpg_key_trust       => 0,
    log_dbg_gpg_exec            => 1,

    log_dbg_session_signal      => 1,
    log_dbg_session_interpreter => 1,
    log_dbg_session_client_tcp  => 1,

    logfile => 'log/dcd.log',
);
tie my %CONF_DEFAULT_SETTINGS, "Tie::IxHash";
%CONF_DEFAULT_SETTINGS =
(
    transport_encryption => 1,
);
tie my %CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT, "Tie::IxHash";
%CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT =
(
    host => '0.0.0.0',
    port => 26667,
    key_id => 0,

);
tie my %CONF_DEFAULT_NODE_CHANNELSERVER, "Tie::IxHash";
%CONF_DEFAULT_NODE_CHANNELSERVER =
(
   _default => \%CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT,
);
tie my %CONF_DEFAULT_NODE, "Tie::IxHash";
%CONF_DEFAULT_NODE =
(
    channelserver => \%CONF_DEFAULT_NODE_CHANNELSERVER,
);
tie my %CONF_DEFAULT_CHANNEL_SERVER, "Tie::IxHash";
%CONF_DEFAULT_CHANNEL_SERVER =
(
    product_name => 'DarkChannel',
    service_name => 'Channel Server',
    protocol_version => 'v1',
    server_type => 'Linux/Perl',

    node     => \%CONF_DEFAULT_NODE,
    gpg      => \%CONF_DEFAULT_GPG,
    log      => \%CONF_DEFAULT_LOG,
    settings => \%CONF_DEFAULT_SETTINGS,
);
tie our %CONF_DEFAULT, "Tie::IxHash";
%CONF_DEFAULT =
(
    channel_server => \%CONF_DEFAULT_CHANNEL_SERVER,
);

1;
