#
# Dark Channel IRC Core Log Client Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Node::Client::Core::Log;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use DarkChannel::Utils::Log;

# Parameters to use POE are not treated as normal imports.
# Rather, they're abbreviated modules to be included along with POE.
use POE qw(Kernel);

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( core_log_info
                  core_log_warn
                  core_log_err
                  core_log_crit
                  core_log_dbg );

sub core_log($;$)
{
    my ($msg, $prefix) = @_;
    my $session = $poe_kernel->get_active_session();
    my $sid = $session->ID;
    my $heap = $session->get_heap();
    my $alias_customer = $heap->{alias_customer};
    my $alias = $heap->{alias};
    my $sap = $alias ? (($alias =~ /.+-([^:\s]+:[0-9]+)/) ? $1 : undef) : undef;
    my @data = ($sid, $sap, $msg, $prefix);

    # use normal logging if no customer receives messages
    dc_log_dbg($msg, $prefix) unless ($alias_customer && $poe_kernel->post($alias_customer, 'darkchannel_LOG_CORE', @data));
    return 1;
}

sub core_log_info($;$)
{
    my ($msg, $prefix) = @_;
    core_log($msg, 'INFO: ' .$prefix);
}

sub core_log_warn($;$)
{
    my ($msg, $prefix) = @_;
    core_log($msg, 'WARN: ' . $prefix);
}

sub core_log_err($;$)
{
    my ($msg, $prefix) = @_;
    core_log($msg, 'ERR: ' . $prefix);
}

sub core_log_crit($;$)
{
    my ($msg, $prefix) = @_;
    core_log($msg, 'CRIT: ' . $prefix);
}

sub core_log_dbg($;$)
{
    my ($msg, $prefix) = @_;
    core_log($msg, 'DBG: ' . $prefix);
}

1;
