#
# Dark Channel TieSTDERR Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Utils::Log::STDERR;

use warnings;
#use strict;

use Carp qw(cluck longmess shortmess);
use Data::Dumper;

sub print_stderr
{
    my $this = shift;
    my $stderr = $this->{STDERR};

    if ( ref($stderr) eq 'SCALAR' ) {
        $$stderr .= $_[0];
    }
    elsif ( ref($stderr) eq 'CODE' ) {
        &$stderr($_[0]);
    }
    else {
        print $stderr $_[0];
    }

    return 1 ;
}

sub TIEHANDLE
{
    my $class = shift ;
    my $self = {
        STDERR => $_[0],
        FH => undef,
    };

    bless($self, $class) ;
}

sub PRINT
{
    my $this = shift ;
    $this->print_stderr(join("", (@_[0..$#_]))) ;
    return 1 ;
}

sub PRINTF {
    &PRINT($_[0], sprintf($_[1],@_[2..$#_]));
}

sub OPEN {
    #
    # ignore open() calls on STDERR, we do not want our STDERR to be redirected
    # somewhere else as we want it all captured and sent to our tie'd anonymous sub
    #
    # if someone needs to use the original STDERR, he needs to untie() this module
    #
    my ($this, $file) = @_;
    $this->print_stderr('open(STDERR, "' . join(', ', @_) . '") called by:' . "\n" . longmess());
    return 1;
}

sub CLOSE {}
sub DESTROY {}
sub READ {}
sub READLINE {}
sub GETC {}
sub WRITE {}
sub FILENO {}

1;
