#
# Dark Channel Text Manipulation Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Utils::Text;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( dc_text_transform_shorten_gpg_blocks );

sub dc_text_transform_shorten_gpg_blocks($)
{
    my $data = shift;
    while ($data =~ s/(-----BEGIN.*BLOCK-----)\n.*?'/$1 ...'/sg) {};
    return $data;
}

1;
